/*
 * Decompiled with CFR 0.152.
 */
package ags.ui.gameSelector;

import ags.communication.TransferHost;
import ags.game.Game;
import ags.ui.IApplication;
import ags.ui.IVirtualScreen;
import ags.ui.IWidget;
import ags.ui.gameSelector.GameInfoWidget;
import ags.ui.gameSelector.GameResultsWidget;
import ags.ui.gameSelector.GameSearchWidget;
import java.io.IOException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GameSelectorApplication
extends IApplication {
    public List<Game> games;
    GameInfoWidget info;
    GameSearchWidget search;
    GameResultsWidget results;

    public GameSelectorApplication(IVirtualScreen s) {
        super(s);
    }

    @Override
    protected void init() {
        this.search = new GameSearchWidget(this);
        this.search.setX(1);
        this.search.setY(1);
        this.search.setXSize(38);
        this.search.setYSize(22);
        this.info = new GameInfoWidget(this);
        this.info.setX(1);
        this.info.setXSize(38);
        this.info.setY(1);
        this.info.setYSize(7);
        this.results = new GameResultsWidget(this);
        this.results.setX(1);
        this.results.setXSize(38);
        this.results.setY(10);
        this.results.setYSize(13);
        this.addWidget(this.results);
        this.addWidget(this.info);
        this.moveToTop(this.results);
    }

    public void mainLoop(TransferHost host) throws IOException {
        this.redraw();
        this.getScreen().send(host);
        while (this.gameSelected() == null) {
            byte key = host.getKey();
            if (key == 0 || !this.handleKeypress(key)) continue;
            this.getScreen().send(host);
        }
        host.toggleSwitch(49233);
        host.toggleSwitch(49236);
        host.startGame(this.gameSelected());
        System.out.println("Have fun playing " + this.gameSelected().getName() + "!");
    }

    @Override
    protected boolean handleGlobalKeypress(byte b) {
        if (b == 9) {
            IWidget newTop = (IWidget)this.visible.get(0);
            if (newTop == this.search) {
                newTop = (IWidget)this.visible.get(1);
            }
            this.moveToTop(newTop);
            return true;
        }
        if (b == 27) {
            if (this.info.isActive() || this.results.isActive()) {
                this.removeWidget(this.info);
                this.removeWidget(this.results);
                this.addWidget(this.search);
                this.search.show();
                this.moveToTop(this.search);
                return true;
            }
            if (this.search.isActive()) {
                this.setResults(this.games);
                this.removeWidget(this.search);
                this.search.hide();
                this.addWidget(this.info);
                this.addWidget(this.results);
                this.moveToTop(this.results);
                return true;
            }
        }
        if (b == 13 && this.search.isActive()) {
            this.removeWidget(this.search);
            this.search.hide();
            this.addWidget(this.info);
            this.addWidget(this.results);
            this.moveToTop(this.results);
            return true;
        }
        return false;
    }

    @Override
    protected boolean handleInvalidKeypress(byte b) {
        return false;
    }

    public void setGames(List<Game> games) {
        this.games = games;
        this.setResults(games);
    }

    public void setResults(List<Game> games) {
        this.results.results = games;
        this.results.activeItem = 0;
        if (games != null && games.size() > 0) {
            GameInfoWidget.setActiveItem(games.get(0));
        }
    }

    public Game gameSelected() {
        return this.results.selection;
    }
}

